/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics.model;

import dev.mayaqq.estrogen.client.cosmetics.model.BakedCosmeticModel;
import dev.mayaqq.estrogen.client.cosmetics.model.BlockElementGroup;
import dev.mayaqq.estrogen.client.cosmetics.model.PreparedModel;
import dev.mayaqq.estrogen.client.cosmetics.model.mesh.MeshTree;
import dev.mayaqq.estrogen.client.cosmetics.model.mesh.SimpleMesh;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_753;
import net.minecraft.class_783;
import net.minecraft.class_7833;
import net.minecraft.class_785;
import net.minecraft.class_787;
import net.minecraft.class_789;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@ParametersAreNonnullByDefault
public final class CosmeticModelBakery {
    private static final float RESCALE_22_5 = 1.0f / (float)Math.cos((double)0.3926991f) - 1.0f;
    private static final float RESCALE_45 = 1.0f / (float)Math.cos((double)0.7853981852531433) - 1.0f;
    private static final float PACK = 127.0f;
    private static final float UNPACK = 0.007874016f;
    private final PreparedModel model;
    private final Vector3f minBound = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
    private final Vector3f maxBound = new Vector3f();
    private final Vector4f position = new Vector4f();
    private final Vector3f normal = new Vector3f();
    private final Matrix4f modelMat = new Matrix4f();
    private final Matrix3f normalMat = new Matrix3f();

    public CosmeticModelBakery(PreparedModel model) {
        this.model = model;
    }

    public static BakedCosmeticModel bake(PreparedModel model) {
        CosmeticModelBakery bakery = new CosmeticModelBakery(model);
        return model.hasGroups() ? bakery.bakeGrouped() : bakery.bakeSimple();
    }

    public BakedCosmeticModel bakeSimple() {
        return new BakedCosmeticModel(this.bakeMesh(this.model.elements()), this.minBound, this.maxBound);
    }

    public BakedCosmeticModel bakeGrouped() {
        List<class_785> elements = this.model.elements();
        MeshTree.Builder builder = MeshTree.builder();
        IntSet ungrouped = IntStream.range(0, elements.size()).collect(() -> CosmeticModelBakery.createIntSet(elements.size()), IntCollection::add, IntCollection::addAll);
        for (BlockElementGroup rootGroup : this.model.groups()) {
            builder.addChild(rootGroup.name(), this.compileGroup(rootGroup, index -> {
                if (!ungrouped.remove(index)) {
                    throw new IllegalStateException("Element #%d referenced in multiple groups".formatted(index));
                }
                return (class_785)elements.get(index);
            }));
        }
        if (!ungrouped.isEmpty()) {
            builder.mesh(this.bakeMesh(ungrouped.intStream().mapToObj(elements::get).toList()));
        }
        return new BakedCosmeticModel(builder.build(), this.minBound, this.maxBound);
    }

    public MeshTree compileGroup(BlockElementGroup group, IntFunction<class_785> elementGetter) {
        List<class_785> elements = group.elementIndices().intStream().mapToObj(elementGetter).toList();
        MeshTree.Builder builder = MeshTree.builder().mesh(this.bakeMesh(elements)).origin(new Vector3f((Vector3fc)group.origin()).div(16.0f));
        for (BlockElementGroup subGroup : group.subGroups()) {
            builder.addChild(subGroup.name(), this.compileGroup(subGroup, elementGetter));
        }
        return builder.build();
    }

    public SimpleMesh bakeMesh(List<class_785> elements) {
        int vertices = elements.stream().mapToInt(e -> e.field_4230.size()).sum() * 4;
        int[] vertexData = new int[vertices * 6];
        int index = 0;
        for (class_785 element : elements) {
            this.modelMat.identity();
            this.normalMat.identity();
            float[] shape = CosmeticModelBakery.setupShape(element.field_4228, element.field_4231);
            class_789 rot = element.field_4232;
            if (rot != null) {
                this.applyElementRotation(rot, this.modelMat, this.normalMat);
            }
            for (Map.Entry entry : element.field_4230.entrySet()) {
                class_2350 direction = (class_2350)entry.getKey();
                class_787 uv = ((class_783)entry.getValue()).field_4227;
                class_753 face = class_753.method_3163((class_2350)direction);
                for (int i = 0; i < 4; ++i) {
                    class_753.class_755 vertex = face.method_3162(i);
                    this.position.set(shape[vertex.field_3975], shape[vertex.field_3974], shape[vertex.field_3973], 1.0f);
                    this.modelMat.transform(this.position);
                    float u = uv.method_3415(i) / 16.0f;
                    float v = uv.method_3416(i) / 16.0f;
                    this.normal.set((float)direction.method_10148(), (float)direction.method_10164(), (float)direction.method_10165());
                    this.normalMat.transform(this.normal);
                    int pos = index * 6;
                    vertexData[pos] = Float.floatToRawIntBits(this.position.x);
                    vertexData[pos + 1] = Float.floatToRawIntBits(this.position.y);
                    vertexData[pos + 2] = Float.floatToRawIntBits(this.position.z);
                    vertexData[pos + 3] = Float.floatToRawIntBits(u);
                    vertexData[pos + 4] = Float.floatToRawIntBits(v);
                    vertexData[pos + 5] = CosmeticModelBakery.packNormal(this.normal.x, this.normal.y, this.normal.z);
                    this.minBound.set(Math.min((float)this.minBound.x, (float)this.position.x), Math.min((float)this.minBound.y, (float)this.position.y), Math.min((float)this.minBound.z, (float)this.position.z));
                    this.maxBound.set(Math.max((float)this.maxBound.x, (float)this.position.x), Math.max((float)this.maxBound.y, (float)this.position.y), Math.max((float)this.maxBound.z, (float)this.position.z));
                    ++index;
                }
            }
        }
        return new SimpleMesh(vertexData, vertices);
    }

    private static float[] setupShape(Vector3f min, Vector3f max) {
        float[] fs = new float[class_2350.values().length];
        fs[class_753.class_754.field_3967] = min.x() / 16.0f;
        fs[class_753.class_754.field_3968] = min.y() / 16.0f;
        fs[class_753.class_754.field_3969] = min.z() / 16.0f;
        fs[class_753.class_754.field_3970] = max.x() / 16.0f;
        fs[class_753.class_754.field_3971] = max.y() / 16.0f;
        fs[class_753.class_754.field_3972] = max.z() / 16.0f;
        return fs;
    }

    private void applyElementRotation(class_789 rotation, Matrix4f modelMat, Matrix3f normalMat) {
        Vector3f origin = rotation.comp_1118();
        modelMat.translate(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f);
        Quaternionf quat = this.axisRotation(rotation.comp_1119(), rotation.comp_1120());
        modelMat.rotate((Quaternionfc)quat);
        normalMat.rotate((Quaternionfc)quat);
        if (rotation.comp_1121()) {
            Vector3f scale = this.getRescaleVector(rotation.comp_1119());
            scale.mul(Math.abs((float)rotation.comp_1120()) == 22.5f ? RESCALE_22_5 : RESCALE_45);
            modelMat.scale(scale.x, scale.y, scale.z);
            float nx = 1.0f / scale.x;
            float ny = 1.0f / scale.y;
            float nz = 1.0f / scale.z;
            float i = class_3532.method_23278((float)(nx * ny * nz));
            normalMat.scale(nx * i, ny * i, nz * i);
        }
        modelMat.translate(-(origin.x / 16.0f), -(origin.y / 16.0f), -(origin.z / 16.0f));
    }

    private Vector3f getRescaleVector(class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> new Vector3f(0.0f, 1.0f, 1.0f);
            case class_2350.class_2351.field_11052 -> new Vector3f(1.0f, 0.0f, 1.0f);
            case class_2350.class_2351.field_11051 -> new Vector3f(1.0f, 1.0f, 0.0f);
        };
    }

    private Quaternionf axisRotation(class_2350.class_2351 axis, float degrees) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> class_7833.field_40714.rotationDegrees(degrees);
            case class_2350.class_2351.field_11052 -> class_7833.field_40716.rotationDegrees(degrees);
            case class_2350.class_2351.field_11051 -> class_7833.field_40718.rotationDegrees(degrees);
        };
    }

    public static int packNormal(float x, float y, float z) {
        x = class_3532.method_15363((float)x, (float)-1.0f, (float)1.0f);
        y = class_3532.method_15363((float)y, (float)-1.0f, (float)1.0f);
        z = class_3532.method_15363((float)z, (float)-1.0f, (float)1.0f);
        return (int)(x * 127.0f) & 0xFF | ((int)(y * 127.0f) & 0xFF) << 8 | ((int)(z * 127.0f) & 0xFF) << 16;
    }

    public static float unpackNX(int packedNormal) {
        return (float)((byte)(packedNormal & 0xFF)) * 0.007874016f;
    }

    public static float unpackNY(int packedNormal) {
        return (float)((byte)(packedNormal >>> 8 & 0xFF)) * 0.007874016f;
    }

    public static float unpackNZ(int packedNormal) {
        return (float)((byte)(packedNormal >>> 16 & 0xFF)) * 0.007874016f;
    }

    public static Vector3f unpackNormal(int packedNormal, Vector3f dest) {
        dest.set(CosmeticModelBakery.unpackNX(packedNormal), CosmeticModelBakery.unpackNY(packedNormal), CosmeticModelBakery.unpackNZ(packedNormal));
        return dest;
    }

    private static IntSet createIntSet(int size) {
        return size > 4 ? new IntOpenHashSet() : new IntArraySet();
    }
}

